CREATE OR REPLACE FUNCTION addColumn() 
RETURNS VOID AS 
$BODY$ 
BEGIN 
	IF EXISTS (SELECT 1 FROM information_schema.columns 
					WHERE table_name= 'v_pdv_vd_cred') THEN 
		DROP VIEW v_pdv_vd_cred;
		RAISE NOTICE 'v_pdv_vd_cred Dropada.';
	END IF;
	
	CREATE OR REPLACE VIEW public.v_pdv_vd_cred
	AS SELECT a.cd_emp,
    a.cd_filial,
    a.cd_vd,
    a.cd_cx,
    a.cd_cli,
    a.nr_ecf,
    a.dt_vd,
    a.vlr_cartao,
    b.cd_parc,
    b.dt_parc,
    b.vl_parc,
    a.qt_parc_cred,
    b.nr_fatura,
    a.cd_usu,
    COALESCE(a.flag_consolidado, 0) AS flag_consolidado,
    a.st_vd,
    ( SELECT
                CASE a.st_vd
                    WHEN 0 THEN 0
                    WHEN 1 THEN 2
                    ELSE NULL::integer
                END AS "case") AS sts_lanc_cred,
    a.nm_comprador,
    d.cd_mdl_vd,
    d.rz_cli,
    d.cgc_cpf,
    f.qt_parc,
    COALESCE(e.ds_mdl_vd, ''::character varying, e.ds_mdl_vd) AS ds_mdl_vd
   FROM pdv_vd a
     JOIN pdv_vd_cred b ON a.cd_emp = b.cd_emp AND a.cd_filial = b.cd_filial AND a.cd_vd = b.cd_vd
     JOIN rc_cli_crediario d ON d.cd_cli = a.cd_cli
     JOIN rc_mdl_venda e ON d.cd_mdl_vd = e.cd_mdl_vd
     JOIN pdv_vd_tef f ON a.cd_emp = f.cd_emp AND a.cd_filial = f.cd_filial AND a.cd_vd = f.cd_vd AND  F.tipo_transacao = 3
  ORDER BY b.cd_parc;

END; 
-- fim bloco principal 
$BODY$ 
LANGUAGE plpgsql VOLATILE 
  COST 100; 
ALTER FUNCTION addColumn() OWNER TO postgres; 
SELECT addColumn(); 
DROP FUNCTION addColumn();